import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{value} %': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '{value} %',
        ru: '{value} %',
        cs: '{value} %',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
