import { EMPTY_DATA } from 'constants/constants';

import { formatNumber } from 'shared/helpers/formatNumber/formatNumber';

import { i18n } from 'shared/helpers/formatUtilization/formatUtilization.i18n';

export function formatUtilization(value?: number): string {
    if (value === undefined) {
        return EMPTY_DATA;
    }

    return i18n('{value} %', {
        value: formatNumber(value, {
            minimumFractionDigits: 1,
            maximumFractionDigits: 1,
        }),
    });
}
