import { MonthType } from '@datepicker-react/hooks/lib/useDatepicker/useDatepicker.utils';

export function getCalendarMonths(date: Nullable<Date>, step: number = 1): MonthType[] {
    const initialDate = date || new Date();
    const isNegative = step < 0;

    let months: MonthType[] = [];

    for (let i = 0; i < Math.abs(step); i++) {
        const date = new Date(initialDate.getFullYear(), initialDate.getMonth() + (isNegative ? -i : i), 1);
        const month: MonthType = {
            date,
            month: date.getMonth(),
            year: date.getFullYear(),
        };

        months.push(month);
    }

    return months;
}
