import { ONE_SECOND } from 'constants/constants';

import { DateAggregationDuration } from 'shared/consts/DateAggregationDuration';
import { DateAggregationConfig } from 'shared/helpers/getDateAggregation/getDateAggregation';
import { getDateEndDayTime } from 'shared/helpers/getDateEndDayTime/getDateEndDayTime';
import { getDateStartDayTime } from 'shared/helpers/getDateStartDayTime/getDateStartDayTime';
import { ChartPoint } from 'shared/types/ChartPoint';

function getClosestChartPointsValues(points: ChartPoint[], timestamp: number, delta: number): number {
    const leftT = timestamp - delta / 2;
    const rightT = timestamp + delta / 2;

    return points.reduce((memo, point) => {
        if (leftT < point.begin_date && point.begin_date <= rightT) {
            return (memo + (point.line1 as number)) / 2;
        }

        return memo;
    }, 0);
}

export function getChartAggregatedPoints(points: ChartPoint[], config: DateAggregationConfig): ChartPoint[] {
    const { aggregation, since, until } = config;

    if (!since || !until) {
        return points;
    }

    const sinceDate = since * ONE_SECOND;
    const untilDate = until * ONE_SECOND;

    let currentPoint: ChartPoint = {
        begin_date: getDateStartDayTime(sinceDate),
        end_date: getDateEndDayTime(sinceDate + DateAggregationDuration[aggregation] - 1),
        line1: getClosestChartPointsValues(
            points,
            getDateStartDayTime(sinceDate),
            DateAggregationDuration[aggregation],
        ),
    };
    let aggregatedPoints: ChartPoint[] = [currentPoint];

    while (currentPoint.begin_date + DateAggregationDuration[aggregation] < untilDate) {
        aggregatedPoints.push({
            begin_date: currentPoint.begin_date + DateAggregationDuration[aggregation],
            end_date: currentPoint.end_date + DateAggregationDuration[aggregation],
            line1: getClosestChartPointsValues(points, currentPoint.begin_date, DateAggregationDuration[aggregation]),
        });

        currentPoint = aggregatedPoints[aggregatedPoints.length - 1];
    }

    return aggregatedPoints;
}
