import { bisector } from 'd3-array';

import { ChartPoint } from 'shared/types/ChartPoint';

const bisectDate = bisector<ChartPoint, number>((point) => point.begin_date).center;

export function getChartClosePointIndex(points: ChartPoint[], timestamp: number): number {
    if (!points.length) {
        return -1;
    }

    let i = bisectDate(points, timestamp, 1);

    let left = points[i - 1];
    let right = points[i];

    return right && timestamp - left.begin_date > right.begin_date - timestamp ? i : i - 1;
}
