import { ONE_SECOND } from 'constants/constants';

import { DateAggregationDuration } from 'shared/consts/DateAggregationDuration';
import { DateAggregationConfig } from 'shared/helpers/getDateAggregation/getDateAggregation';
import { getDateEndDayTime } from 'shared/helpers/getDateEndDayTime/getDateEndDayTime';
import { getDateStartDayTime } from 'shared/helpers/getDateStartDayTime/getDateStartDayTime';
import { ChartPoint } from 'shared/types/ChartPoint';

export function getChartFilledPoints(points: ChartPoint[], config: DateAggregationConfig): ChartPoint[] {
    if (!points.length) {
        return [];
    }

    let filledPoints: ChartPoint[] = [points[0]];
    const { aggregation, since, until } = config;
    let startPointIndex = 1;

    if (since) {
        const sinceDate = since * ONE_SECOND;

        if (sinceDate + DateAggregationDuration[aggregation] < points[0].begin_date) {
            filledPoints = [
                {
                    begin_date: getDateStartDayTime(sinceDate),
                    end_date: getDateEndDayTime(sinceDate + DateAggregationDuration[aggregation] - 1),
                    isMissed: true,
                },
            ];
            startPointIndex = 0;
        }
    }

    for (let i = startPointIndex; i < points.length; i++) {
        let lastFilled = filledPoints[filledPoints.length - 1];
        let currentPoint = points[i];
        let currentPointStartDay = getDateStartDayTime(currentPoint.begin_date);

        while (lastFilled.end_date + DateAggregationDuration[aggregation] < currentPointStartDay) {
            filledPoints.push({
                begin_date: getDateStartDayTime(lastFilled.end_date + DateAggregationDuration[aggregation]),
                end_date: getDateEndDayTime(lastFilled.end_date + DateAggregationDuration[aggregation] - 1),
                isMissed: true,
            });

            lastFilled = filledPoints[filledPoints.length - 1];
        }

        filledPoints.push(currentPoint);
    }

    if (until) {
        const untilDate = until * ONE_SECOND;
        let lastFilledEndDate = filledPoints[filledPoints.length - 1].end_date;

        while (lastFilledEndDate < untilDate) {
            filledPoints.push({
                begin_date: getDateStartDayTime(lastFilledEndDate + DateAggregationDuration[aggregation]),
                end_date: getDateEndDayTime(lastFilledEndDate + DateAggregationDuration[aggregation]),
                isMissed: true,
            });

            lastFilledEndDate = filledPoints[filledPoints.length - 1].end_date;
        }
    }

    return filledPoints;
}
