/* eslint-disable @typescript-eslint/no-magic-numbers */
import { d3Max } from 'shared/helpers/d3Max/d3Max';
import { ChartKey, ChartPoint } from 'shared/types/ChartPoint';

export type GetChartRangeValueResult = {
    from: number;
    to: number;
};

function getValueWithRatio(value: number, min?: boolean): number {
    let kf = 100;

    if (value < 20) {
        kf = 4;
    } else if (value < 1000) {
        kf = 20;
    }

    return Math.ceil(value / kf) * kf - (min ? kf : 0);
}

function getRoundValue(value: number): number {
    return Math.round(value * 100) / 100;
}

export function getChartRangeValue(points: ChartPoint[], key: ChartKey, max?: number): GetChartRangeValueResult {
    let maxPoint = d3Max(points, key) || 1;
    let minPoint = 0;
    let step = (maxPoint - minPoint) / 3;

    let from;
    let to;

    if (step < 1) {
        from = getRoundValue(minPoint - step);
        to = getRoundValue(maxPoint + step);
    } else {
        from = getValueWithRatio(minPoint, minPoint > 0);
        to = getValueWithRatio(maxPoint);
    }

    if (max) {
        to = max === 100 ? Math.max(to, max) : Math.min(to, max);
    }

    return { from: Math.max(from, 0), to: to };
}
