import { DAYS_IN_MONTH, HOURS_IN_DAY, SECONDS_IN_HOUR } from 'constants/constants';

import { DateAggregation } from 'shared/consts/DateAggregation';

export interface GetDateAggregationProps {
    since?: Nullable<number>;
    until?: Nullable<number>;
}

export interface DateAggregationConfig {
    aggregation: DateAggregation;
    since?: Nullable<number>;
    until?: Nullable<number>;
}

const MAX_WEEK_AGGREGATION = 9;
const MAX_DAY_AGGREGATION = 3;

export function getDateAggregation(props: GetDateAggregationProps): DateAggregationConfig {
    const { since, until } = props;

    if (until && since) {
        const delta = new Date(until).getTime() - new Date(since).getTime();
        const deltaDays = Math.floor(delta / HOURS_IN_DAY / SECONDS_IN_HOUR);

        if (deltaDays >= DAYS_IN_MONTH * MAX_WEEK_AGGREGATION) {
            return {
                ...props,
                aggregation: DateAggregation.MONTH,
            };
        }

        if (deltaDays >= DAYS_IN_MONTH * MAX_DAY_AGGREGATION) {
            return {
                ...props,
                aggregation: DateAggregation.WEEK,
            };
        }
    }

    return {
        ...props,
        aggregation: DateAggregation.DAY,
    };
}
