import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Avg. per day': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Avg. per day',
        ru: 'Сред. в день',
        cs: 'Průměr za den',
    },
    'Avg. per month': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Avg. per month',
        ru: 'Сред. в месяц',
        cs: 'Průměr za měsíc',
    },
    'Avg. per week': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Avg. per week',
        ru: 'Сред. в неделю',
        cs: 'Průměr za týden',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
