import { DateAggregation } from 'shared/consts/DateAggregation';

import { i18n } from 'shared/helpers/getDateAggregationLabel/getDateAggregationLabel.i18n';

const AVERAGE_PER_TIME: Record<DateAggregation, string> = {
    [DateAggregation.DAY]: i18n('Avg. per day'),
    [DateAggregation.WEEK]: i18n('Avg. per week'),
    [DateAggregation.MONTH]: i18n('Avg. per month'),
};

export function getDateAggregationLabel(aggregation: DateAggregation) {
    return AVERAGE_PER_TIME[aggregation];
}
