export function getDatesInYear(since: Date, until: Date): Array<{ year: number; dates: Date[] }> {
    let current = new Date(since);
    let months: Record<string, Date[]> = {};

    if (since >= until) {
        throw new Error('Input parameter error. Date since greater then until');
    }

    while (current < until) {
        const key = current.getFullYear() + '-' + current.getMonth();

        if (!months[key]) {
            months[key] = [];
        }

        months[key].push(new Date(current));

        current.setDate(current.getDate() + 1);
    }

    return Object.keys(months).map((key) => {
        return {
            year: months[key][0].getFullYear(),
            dates: months[key],
        };
    });
}
