import { FetchError } from 'shared/helpers/fetchRequest/fetchRequest';
import { FormErrorSchema } from 'shared/types/FormErrorSchema';

import { i18n } from 'shared/helpers/getFetchErrorMessage/getFetchErrorMessage.i18n';

export function getFetchErrorMessage(error: Error): FormErrorSchema {
    if (error instanceof FetchError) {
        const title = error.canceled ? i18n('Something went wrong') : error.res?.error_details?.ui_title;
        const message = error.canceled ? i18n('Please try again') : error.res?.error_details?.ui_message;
        const query = new URLSearchParams(error.req.query);
        const reqid = query.get('reqid') || '';

        return [
            { message: title, code: 'title' },
            { message: message, code: 'message' },
            { message: `reqid: ${reqid}`, code: 'reqid' },
        ].filter(({ message }) => Boolean(message));
    }

    throw error;
}
