import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{dayString} at {timeString}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '{dayString} at {timeString}',
        ru: '{dayString} в {timeString}',
        cs: '{DayString} v {timeString}',
    },
    Today: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Today',
        ru: 'Сегодня',
        cs: 'Dnes',
    },
    Yesterday: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Yesterday',
        ru: 'Вчера',
        cs: 'Včera',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
