import { ONE_SECOND } from 'constants/constants';

import { getI18nLocale } from 'utils/language/getI18nLocale';

import { i18n } from 'shared/helpers/getLastUpdateString/getLastUpdateString.i18n';

export function getLastUpdateString(lastUpdate?: number): Nullable<string> {
    if (!lastUpdate) {
        return null;
    }

    let lastUpdateDate = lastUpdate > 0 && new Date(lastUpdate * ONE_SECOND);

    if (lastUpdateDate) {
        const locale = getI18nLocale();

        let currentDate = new Date();
        let currentDay = currentDate.getDate();
        let currentMonth = currentDate.getMonth();

        let yesterdayDate = new Date();
        yesterdayDate.setDate(yesterdayDate.getDate() - 1);
        let yesterdayDay = yesterdayDate.getDate();
        let yesterdayMonth = yesterdayDate.getMonth();

        let day = lastUpdateDate.getDate();
        let month = lastUpdateDate.getMonth();

        const isToday = day === currentDay && month === currentMonth;
        const isYesterday = day === yesterdayDay && month === yesterdayMonth;

        const dayString = isToday
            ? i18n('Today')
            : isYesterday
            ? i18n('Yesterday')
            : lastUpdateDate.toLocaleString(locale, {
                  day: 'numeric',
                  month: 'short',
              });

        const timeString = lastUpdateDate.toLocaleString(locale, {
            hour: '2-digit',
            minute: '2-digit',
        });

        return i18n('{dayString} at {timeString}', {
            dayString,
            timeString,
        });
    } else {
        return null;
    }
}
