export interface GetSearchFiltersValues {
    stringFilters?: string[];
    booleanFilters?: string[];
    dateFilters?: string[];
}

// @todo: add test
export function getSearchParamsFilters<T>(
    searchParams: URLSearchParams,
    filters: T,
    values: GetSearchFiltersValues,
): T {
    const { stringFilters, booleanFilters, dateFilters } = values;

    let searchFilters: T = { ...filters };

    stringFilters?.forEach((filter) => {
        searchFilters[filter] = searchParams.get(filter);
    });

    booleanFilters?.forEach((filter) => {
        if (searchParams.get(filter) === 'true') {
            searchFilters[filter] = true;
        }

        if (searchParams.get(filter) === 'false' || searchParams.get(filter) === null) {
            searchFilters[filter] = false;
        }
    });

    dateFilters?.forEach((filter) => {
        const value = searchParams.get(filter);

        if (filters[filter] !== value && value !== null) {
            searchFilters[filter] = Number(value);
        }
    });

    return searchFilters;
}
