import { GPSSignalLevel } from 'shared/consts/GPSValueIcon';
export const SIGNAL_LEVEL_RED = 10;
export const SIGNAL_LEVEL_YELLOW = 13;

export const getSignalLevel = (signal: number | null | undefined): string => {
    if (!signal || signal === 0) {
        return GPSSignalLevel.NONE;
    }

    if (signal < SIGNAL_LEVEL_RED) {
        return GPSSignalLevel.RED;
    } else if (signal < SIGNAL_LEVEL_YELLOW) {
        return GPSSignalLevel.YELLOW;
    }

    return GPSSignalLevel.GREEN;
};
