export function isValidNumber(str?: Nullish<string | number>): boolean {
    if (typeof str === 'string') {
        const replacedString = str.replace(/,|\s/g, '');

        return !isNaN(Number(replacedString)) && !isNaN(parseFloat(replacedString));
    }

    return typeof str === 'number';
}
