import { UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export async function resourceCallbackReader<T>(resource: UseFetchResource<T>): Promise<T> {
    let data: T;

    try {
        data = resource.read();
    } catch (res) {
        if (res instanceof Promise) {
            data = await res;
        } else {
            throw res;
        }
    }

    return data;
}
