import { FormErrorSchema } from 'shared/types/FormErrorSchema';

export function validate<T, S extends Record<string, any>>(
    list: Array<(value: T, store: S) => Optional<FormErrorSchema>>,
): (value: T, store: S) => Optional<FormErrorSchema> {
    return (value, store) => {
        const errors = list.reduce((memo, validator) => {
            const res = validator(value, store);

            if (res) {
                memo.push(...res);
            }

            return memo;
        }, [] as FormErrorSchema);

        return errors.length ? errors : undefined;
    };
}
