import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Invalid e-mail address': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Invalid e-mail address',
        ru: 'Неверный адрес электронной почты',
        cs: 'Neplatná e-mailová adresa',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
