import { EMAIL_MATCH } from 'shared/consts/email';
import { FormErrorSchema } from 'shared/types/FormErrorSchema';

import { i18n } from 'shared/helpers/validateEmail/validateEmail.i18n';

export function validateEmail(code: string = 'invalid_email') {
    return (value: Optional<string>): Optional<FormErrorSchema> => {
        const match = value?.match(EMAIL_MATCH);

        if (value && (!match || !match.length)) {
            return [{ message: i18n('Invalid e-mail address'), code }];
        }

        return undefined;
    };
}
