import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Value should be a number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Value should be a number',
        ru: 'Значение должно быть числом',
        cs: 'Hodnota musí být číslo',
    },
    'Value should be between {min} and {max}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Value should be between {min} and {max}',
        ru: 'Значение должно быть между {min} и {max}',
        cs: 'Hodnota musí být mezi {min} a {max}',
    },
    'Value should be less than {max}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Value should be less than {max}',
        ru: 'Значение должно быть меньше {max}',
        cs: 'Hodnota musí být menší než {max}',
    },
    'Value should be more than {min}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Value should be more than {min}',
        ru: 'Значение должно быть больше {min}',
        cs: 'Hodnota musí být větší než {min}',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
