import { FormErrorSchema } from 'shared/types/FormErrorSchema';

import { i18n } from 'shared/helpers/validateNumber/validateNumber.i18n';

export function validateNumber<T>({ min, max }: { min?: number; max?: number }) {
    return (value: Optional<T>): Optional<FormErrorSchema> => {
        if (value) {
            const num = Number(value);

            if (isNaN(num)) {
                return [{ message: i18n('Value should be a number'), code: 'should_number' }];
            }

            if (min !== undefined && max !== undefined) {
                if (num < min || num > max) {
                    return [
                        {
                            message: i18n('Value should be between {min} and {max}', { min, max }),
                            code: 'should_between',
                        },
                    ];
                }
            } else if (min !== undefined) {
                if (num < min) {
                    return [{ message: i18n('Value should be more than {min}', { min }), code: 'should_more' }];
                }
            } else if (max !== undefined) {
                if (num > max) {
                    return [{ message: i18n('Value should be less than {max}', { max }), code: 'should_less' }];
                }
            }
        }

        return undefined;
    };
}
