import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Invalid phone number format': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Invalid phone number format',
        ru: 'Неверный номер телефона',
        cs: 'Neplatný formát telefonního čísla',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
