import { PHONE_MASKS } from 'shared/consts/phone';
import { FormErrorSchema } from 'shared/types/FormErrorSchema';

import { i18n } from 'shared/helpers/validatePhoneNumber/validatePhoneNumber.i18n';

export function validatePhoneNumber(code: string = 'invalid_phone_number') {
    return (value: Optional<string>): Optional<FormErrorSchema> => {
        let matched;

        const match = PHONE_MASKS.some(({ startsWith, mask }) => {
            if (value?.startsWith(startsWith) && !matched) {
                matched = value.startsWith(startsWith);

                return value.match(mask);
            }

            return;
        });

        if (value && !match) {
            return [{ message: i18n('Invalid phone number format'), code }];
        }

        return undefined;
    };
}
