import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Required value': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Required value',
        ru: 'Введите значение',
        cs: 'Požadovaná hodnota',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
