import { FormErrorSchema } from 'shared/types/FormErrorSchema';

import { i18n } from 'shared/helpers/validateRequired/validateRequired.i18n';

export function validateRequired<T>(message: string = i18n('Required value'), code: string = 'required') {
    return (value: T): Optional<FormErrorSchema> => {
        if (value === undefined || value === null || (typeof value === 'string' && value.trim() === '')) {
            return [{ message, code }];
        }

        return undefined;
    };
}
