import React, { useContext } from 'react';

export class CacheRequestContext {
    private readonly name: string;
    private readonly cache = new Map<string, any>();
    private readonly onChange: Optional<(name: string, payload: Record<string, any>) => void>;

    constructor(
        name: string = '',
        data?: Record<string, any>,
        onChange?: (name: string, payload: Record<string, any>) => void,
    ) {
        this.name = name;
        this.onChange = onChange;

        if (data) {
            Object.keys(data).forEach((key) => {
                this.cache.set(key, data[key]);
            });
        }
    }

    public get<T>(key: string): T {
        return this.cache.get(key) as T;
    }

    public set<T>(key: string, res: T) {
        this.cache.set(key, res);

        this.triggerChange();
    }

    public has(key: string) {
        return this.cache.has(key);
    }

    public getCacheName(): string {
        return this.name;
    }

    private triggerChange() {
        if (this.onChange) {
            const payload: Record<string, any> = {};

            for (let [key, value] of this.cache.entries()) {
                payload[key] = value;
            }
            this.onChange(this.name, payload);
        }
    }
}

export const CacheRequest = React.createContext<CacheRequestContext>(new CacheRequestContext());

export function useCacheRequestContext() {
    return useContext(CacheRequest);
}
