import * as React from 'react';

import { addEventListener } from 'shared/helpers/addEventListener/addEventListener';

interface Event extends MouseEvent {
    target: Element;
}

export function useClickOutside(
    ref: React.RefObject<Optional<HTMLElement>>,
    callback: (event: MouseEvent) => void,
    disabled?: boolean,
) {
    const onMouseDownHandler = React.useCallback(
        (event: MouseEvent) => {
            if (disabled) {
                return;
            }

            if (ref.current && !ref.current.contains((event as Event).target)) {
                callback(event);
            }
        },
        [ref, callback, disabled],
    );

    React.useEffect(() => {
        return addEventListener(document, 'mousedown', onMouseDownHandler);
    }, [onMouseDownHandler]);
}
