import * as React from 'react';

import { isEqual } from 'shared/helpers/isEqual/isEqual';

function cleanObj<T>(obj: T): T {
    return Object.keys(obj).reduce((memo, key) => {
        const val = obj[key];

        if (val !== '' && val !== null && val !== undefined) {
            memo[key] = val;
        }

        return memo;
    }, {} as T);
}

// @todo: add test
export function useEqualDataForm<T>(
    initial: Optional<Partial<T>>,
    callback?: (isEqual: boolean) => void,
): {
    isEqualData: boolean;
    onFormChangeHandler(state: OptionalRecord<T>): void;
} {
    const initialState = React.useRef<OptionalRecord<T>>();

    const [isEqualData, setEqualData] = React.useState<boolean>(true);

    const onFormChangeHandler = React.useCallback(
        (state: OptionalRecord<T>) => {
            let tempEqual: boolean;
            const cleanState = cleanObj<OptionalRecord<T>>(state);

            if (initial) {
                const cleanInitial = cleanObj<Partial<T>>(initial);

                tempEqual = isEqual(cleanInitial, cleanState);
            } else {
                if (!initialState.current) {
                    initialState.current = cleanState;
                }

                tempEqual = initialState.current ? isEqual(initialState.current, cleanState) : true;
            }

            setEqualData(tempEqual);

            if (callback) {
                callback(tempEqual);
            }
        },
        [initial, callback],
    );

    return { isEqualData, onFormChangeHandler };
}
