import * as React from 'react';
import { Middleware, MiddlewareData } from '@floating-ui/core/src/types';
import { autoUpdate, offset, Placement, useFloating } from '@floating-ui/react-dom';

const DEFAULT_OFFSET = 8;

export interface UseFloatingUIOptions {
    placement?: Placement;
    middleware?: Array<Middleware>;

    offset?: number;
    equalWidth?: boolean;
}

export interface UseFloatingUIReturn {
    placement: Placement;
    middlewareData: MiddlewareData;
    style: React.CSSProperties;

    update(): void;
}

export function useFloatingUI(
    referenceRef: React.MutableRefObject<Nullable<HTMLElement>>,
    floatingRef: React.MutableRefObject<Nullable<HTMLElement>>,
    visible?: boolean,
    options?: UseFloatingUIOptions,
): UseFloatingUIReturn {
    const { placement, strategy, middlewareData, x, y, reference, floating, update } = useFloating({
        placement: options?.placement,
        middleware: [...(options?.middleware || []), offset(options?.offset ?? DEFAULT_OFFSET)],
    });

    const style: React.CSSProperties = {
        position: strategy,
        top: y ?? '',
        left: x ?? '',
        width: options?.equalWidth ? referenceRef.current?.clientWidth : '',
    };

    React.useLayoutEffect(() => {
        reference(referenceRef.current);

        if (visible) {
            floating(floatingRef.current);
        }
    }, [referenceRef.current, floatingRef.current, visible]);

    React.useEffect(() => {
        if (!referenceRef.current || !floatingRef.current) {
            return;
        }

        return autoUpdate(referenceRef.current, floatingRef.current, update, {
            animationFrame: true,
        });
    }, [referenceRef.current, floatingRef.current]);

    return { placement, middlewareData, style, update };
}
