import * as React from 'react';

export function useItemRef<T>(setRef?: ((element: Nullable<T>) => void) | React.MutableRefObject<Nullable<T>>): {
    ref: React.MutableRefObject<Nullable<T>>;
    itemRef(element: Nullable<T>): void;
} {
    const ref = React.useRef<Nullable<T>>(null);

    const itemRef = React.useCallback(
        (element: Nullable<T>) => {
            if (setRef) {
                if (typeof setRef === 'function') {
                    setRef(element);
                } else {
                    setRef.current = element;
                }
            }

            ref.current = element;
        },
        [setRef],
    );

    return { ref, itemRef };
}
