import * as React from 'react';

import { KEY_ESC } from 'shared/consts/keys';
import { addEventListener } from 'shared/helpers/addEventListener/addEventListener';

export function useKeyboardMenu(onClose: () => void, disabled?: boolean) {
    let onKeyDownHandler = React.useCallback(
        (event: KeyboardEvent) => {
            if (disabled) {
                return;
            }

            const { keyCode } = event;

            // @todo: add keyboard navigation
            if (keyCode === KEY_ESC) {
                onClose();
            }
        },
        [onClose, disabled],
    );

    React.useEffect(() => {
        return addEventListener(document, 'keydown', onKeyDownHandler);
    }, [onKeyDownHandler]);
}
