import * as React from 'react';

import initMapApi from 'utils/map/map/initMapApi';

import { getAddress } from 'entities/Geo/helpers/getAddress/getAddress';

// @TODO ask Backend
export function useLocationAddress(lat: number | null, lon: number | null, setAddress: (address) => void) {
    const mapScript = initMapApi();

    React.useEffect(() => {
        // @ts-ignore
        if (window.ymaps) {
            getAddress([lon, lat]).then((address) => setAddress(address));
        } else {
            mapScript.addEventListener('load', () => {
                getAddress([lon, lat]).then((address) => setAddress(address));
            });
        }
    }, [lon, lat, setAddress]);
}
