import * as React from 'react';

const defaultOptions: MutationObserverInit = {
    attributes: true,
    characterData: true,
    childList: true,
    subtree: true,
};

export function useMutationObserver(
    ref: React.MutableRefObject<HTMLElement | null>,
    callback: MutationCallback,
    options: MutationObserverInit = defaultOptions,
): void {
    // @ts-ignore
    React.useEffect(() => {
        // Create an observer instance linked to the callback function
        if (ref.current) {
            const observer = new MutationObserver(callback);

            // Start observing the target node for configured mutations
            observer.observe(ref.current, options);

            return () => {
                observer.disconnect();
            };
        }
    }, [callback, options]);
}
