import * as React from 'react';
import { createPortal } from 'react-dom';

import styles from 'shared/hooks/usePortal/usePortal.css';

let portalId: number = 0;

interface UsePortalProps {
    children: React.ReactNode;
}

function createNode(): HTMLDivElement {
    const node = document.createElement('div');
    node.setAttribute('data-portal-id', String(++portalId));
    node.className = styles.portal;

    return node;
}

export function usePortal() {
    const portal = React.useRef<HTMLDivElement>(createNode());

    return React.useCallback(
        function Portal({ children }: UsePortalProps) {
            React.useEffect(() => {
                document.body.appendChild(portal.current);

                return () => {
                    document.body.removeChild(portal.current);
                };
            }, [portal]);

            return createPortal(children, portal.current);
        },
        [portal],
    );
}
