import { RefObject, useLayoutEffect, useRef } from 'react';

import * as ScrollLocker from 'shared/libs/ScrollLocker';

export interface UsePreventScrollOptions {
    enabled: Optional<boolean>;
    containerRef?: RefObject<HTMLElement>;
}

export function usePreventScroll(options: UsePreventScrollOptions) {
    const { enabled, containerRef } = options;
    const elementRef = useRef<HTMLElement | null>(null);
    const lockedRef = useRef(false);

    useLayoutEffect(() => {
        const container = containerRef ? containerRef.current : null;

        if (elementRef.current === container) {
            return;
        }

        if (enabled && lockedRef.current) {
            ScrollLocker.unlock(elementRef.current);
            ScrollLocker.lock(container);
        }

        elementRef.current = container;
    });

    useLayoutEffect(() => {
        if (!enabled) {
            return;
        }

        lockedRef.current = true;
        ScrollLocker.lock(elementRef.current);

        return () => {
            lockedRef.current = false;
            ScrollLocker.unlock(elementRef.current);
        };
    }, [enabled]);
}
