import { UseFetchResource } from 'shared/hooks/useFetch/useFetch';

const cache: Map<string, any> = new Map();

export function useResourceReader<T>(resource: Optional<UseFetchResource<T>>, throwErrors?: boolean): Optional<T> {
    // TODO: add cache cleanup see useFetch -> useEffect destructor

    if (!resource) {
        return;
    }

    const cacheKey = resource.getKey();
    let prevCache;

    if (cache.has(cacheKey)) {
        prevCache = cache.get(cacheKey);
    }

    try {
        const data = resource.read();

        if (data !== prevCache) {
            cache.set(cacheKey, data);

            return data;
        }
    } catch (e) {
        if (e instanceof Promise) {
            throw e;
        } else if (prevCache) {
            return prevCache;
        }

        if (throwErrors) {
            throw e;
        }
    }

    return prevCache;
}
