import * as React from 'react';
import { useCallback, useState } from 'react';

import { HttpStatusCode } from 'shared/consts/HttpStatusCode';
import { FetchError } from 'shared/helpers/fetchRequest/fetchRequest';
import { UseFetchResource } from 'shared/hooks/useFetch/useFetch';
import { useTimerRef } from 'shared/hooks/useTimerRef/useTimerRef';

export function useResourceReloader(resource: UseFetchResource<any>, timeout: number) {
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    const [ver, setVer] = useState<number>(0);
    const rerender = useCallback(() => {
        setVer((ver) => ver + 1);
    }, [setVer]);

    const timerRef = useTimerRef(0);
    let retryable;
    let data;

    try {
        data = resource.read();
    } catch (e) {
        if (e instanceof Promise) {
            e.then(() => {
                rerender();
            });
        } else if (e instanceof FetchError) {
            retryable = e.status >= HttpStatusCode.INTERNAL_SERVER_ERROR;
        }
    }

    React.useEffect(() => {
        if (data || retryable) {
            clearTimeout(timerRef.current);

            timerRef.current = setTimeout(() => {
                resource.reload();
            }, timeout) as unknown as number;
        }
    }, [retryable, data, timerRef, ver, timeout, resource]);
}
