import * as React from 'react';
import { useRef } from 'react';

import { HttpStatusCode } from 'shared/consts/HttpStatusCode';
import { FetchError } from 'shared/helpers/fetchRequest/fetchRequest';

const RETRY_LIMIT = 3;

export function useRetry(error: Optional<FetchError | Error>, reload: () => void): boolean {
    const retryCount = useRef<number>(0);

    React.useEffect(() => {
        if (
            retryCount.current < RETRY_LIMIT &&
            error instanceof FetchError &&
            error.status >= HttpStatusCode.INTERNAL_SERVER_ERROR
        ) {
            retryCount.current++;
            reload();
        }
    }, [error, reload]);

    return retryCount.current >= RETRY_LIMIT;
}
