import * as React from 'react';
import { useHistory, useLocation } from 'react-router-dom';

import {
    GetSearchFiltersValues,
    getSearchParamsFilters,
} from 'shared/helpers/getSearchParamsFilters/getSearchParamsFilters';

export function useSearchFilters<T>(
    initialFilters: T,
    existingFilters: string[],
    values: GetSearchFiltersValues,
    transformer?: (filters: T) => T,
): T {
    const location = useLocation();
    const history = useHistory();

    const [filters, setFilters] = React.useState<T>(initialFilters);

    React.useEffect(() => {
        const searchParams = new URLSearchParams(location?.search);

        existingFilters.forEach((key) => {
            if (filters[key] !== null && !searchParams.get(key)) {
                searchParams.set(key, filters[key]);
            }
        });

        history.replace(`${location.pathname}?${searchParams}`);

        // only first render
    }, []);

    React.useEffect(() => {
        const searchParams = new URLSearchParams(location?.search);

        let searchFilters = getSearchParamsFilters<T>(searchParams, initialFilters, values);

        if (transformer) {
            searchFilters = transformer(searchFilters);
        }

        setFilters(searchFilters);
    }, [transformer, location]);

    return filters;
}
