import * as React from 'react';
import { useHistory, useLocation } from 'react-router-dom';

export function useSearchParam(name: string): [Optional<string>, (value: Optional<string>) => void] {
    const location = useLocation();
    const history = useHistory();

    const value = React.useMemo<Optional<string>>(() => {
        const searchParams = new URLSearchParams(location?.search);
        const value = searchParams.get(name);

        return value === null ? undefined : value;
    }, [location]);

    const setValue = React.useCallback(
        (value: Optional<string>) => {
            const searchParams = new URLSearchParams(location?.search);

            if (value) {
                searchParams.set(name, value);
            } else {
                searchParams.delete(name);
            }

            history.replace(`${location.pathname}?${searchParams}`);
        },
        [location, history],
    );

    return [value, setValue];
}
