import * as React from 'react';

export function useTimerRef(initialValue?: number): React.MutableRefObject<number> {
    const timerRef = React.useRef<number>(initialValue || 0);

    React.useEffect(() => {
        return () => {
            if (timerRef.current) {
                clearTimeout(timerRef.current);

                timerRef.current = 0;
            }
        };
    }, []);

    return timerRef;
}
