import * as React from 'react';

import { addEventListener } from 'shared/helpers/addEventListener/addEventListener';

import styles from 'shared/hooks/usePortal/usePortal.css';

function createInputFile(): HTMLInputElement {
    const node = document.createElement('input');
    node.setAttribute('type', 'file');
    node.setAttribute('accept', 'application/JSON');
    node.className = styles.portal;

    return node;
}

export function useUploadFile(onFileChange: (file: File) => void) {
    const input = React.useRef<HTMLInputElement>(createInputFile());

    const onChange = React.useCallback(
        (event) => {
            const file = event.target.files[0];

            if (file) {
                onFileChange(file);
            }
        },
        [onFileChange],
    );

    const upload = React.useCallback(() => {
        input.current.click();
    }, []);

    React.useEffect(() => {
        return addEventListener(input.current, 'change', onChange);
    }, []);

    return {
        upload,
    };
}
