import * as StandartScrollLocker from 'shared/libs/ScrollLocker/StandartScrollLocker';
import * as TouchScrollLocker from 'shared/libs/ScrollLocker/TouchScrollLocker';
import { isIOS } from 'shared/libs/ScrollLocker/utils';

function ensureElement(element?: HTMLElement | null) {
    return element || document.body;
}

/**
 * Добавляет запрет на прокрутку содержимого на DOM-элементе.
 *
 * @param container Ссылка на DOM-элемент. По-умолчанию: `document.body`
 */
export function lock(container?: HTMLElement | null) {
    if (typeof window === 'undefined') {
        return;
    }

    const element = ensureElement(container);

    StandartScrollLocker.lock(element);

    if (isIOS()) {
        TouchScrollLocker.lock(element);
    }
}

/**
 * Убирает запрет на прокрутку содержимого на DOM-элементе.
 *
 * @param container Ссылка на DOM-элемент. По-умолчанию: `document.body`
 */
export function unlock(container?: HTMLElement | null) {
    if (typeof window === 'undefined') {
        return;
    }

    const element = ensureElement(container);

    StandartScrollLocker.unlock(element);

    if (isIOS()) {
        TouchScrollLocker.unlock(element);
    }
}
