import * as React from 'react';
import cn from 'classnames';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button } from 'shared/ui/Button/Button';
import { Widget } from 'shared/ui/Widget/Widget';

import CloseIcon from 'shared/ui/Icons/images/close-24.inline.svg';

import styles from 'shared/ui/BaseDialog/BaseDialog.css';

export interface BaseDialogProps {
    className?: string;
    overlayClassName?: string;
    title?: React.ReactNode;
    description?: React.ReactNode;
    hasClose?: boolean;
    controls?: React.ReactNode;
    hasOverlay?: boolean;

    onClose?(): void;

    onOverlayClick?(): void;
}

export const BaseDialog: React.FC<BaseDialogProps> = function BaseDialog({
    className,
    overlayClassName,
    title,
    description,
    hasClose,
    controls,
    hasOverlay,
    onClose,
    onOverlayClick,
    children,
}) {
    return (
        <>
            {hasOverlay && (
                <button
                    className={cn(styles.overlay, overlayClassName)}
                    onClick={onOverlayClick}
                />
            )}

            <Widget
                className={cn(styles.dialog, className)}
                role="dialog"
            >
                {hasClose && (
                    <Button
                        className={styles.close}
                        size={ButtonSize.M}
                        color={ButtonColor.CLEAR}
                        icon={CloseIcon}
                        round
                        onClick={onClose}
                    />
                )}

                {title && (
                    <div className={styles.header}>
                        {typeof title === 'string' ? (
                            <h3 className={styles.title}>{title}</h3>
                        ) : (
                            title && <div className={styles.title}>{title}</div>
                        )}

                        {typeof description === 'string' ? (
                            <p className={styles.description}>{description}</p>
                        ) : (
                            description && <div className={styles.description}>{description}</div>
                        )}
                    </div>
                )}

                {children}

                {controls && <div className={styles.controls}>{controls}</div>}
            </Widget>
        </>
    );
};
