import * as React from 'react';
import cn from 'classnames';

import ArrowIcon from 'shared/ui/Icons/images/arrow-short-forward-12.inline.svg';

import styles from 'shared/ui/Breadcrumbs/Breadcrumbs.css';

export interface BreadcrumbsProps {
    className?: string;
    items: string[];
}

export const Breadcrumbs: React.FC<BreadcrumbsProps> = function Breadcrumbs({ className, items }) {
    if (!items) {
        return null;
    }

    return (
        <ul className={cn(styles.breadcrumbs, className)}>
            {items.map((item, key) => (
                <li
                    className={styles.item}
                    key={key}
                >
                    {item}

                    <ArrowIcon className={styles.icon} />
                </li>
            ))}
        </ul>
    );
};
