import React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button, ButtonProps } from 'shared/ui/Button/Button';

import ArrowBackIcon from 'shared/ui/Icons/images/arrow-short-back-16.inline.svg';

const storybookMeta = createStorybookMeta<ButtonProps>({
    title: 'shared/Button',
    component: Button,

    args: {
        size: ButtonSize.M,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<
    ButtonProps,
    React.ForwardRefExoticComponent<React.PropsWithoutRef<ButtonProps> & React.RefAttributes<any>>
>(Button);

export const primary = Template.bind({});
primary.args = { color: ButtonColor.PRIMARY, label: 'Button' };
primary.hermioneFn = hoverState;

export const secondary = Template.bind({});
secondary.args = { color: ButtonColor.SECONDARY, label: 'Button' };
secondary.hermioneFn = hoverState;

export const alarm = Template.bind({});
alarm.args = { color: ButtonColor.ALARM, label: 'Button' };
alarm.hermioneFn = hoverState;

export const clear = Template.bind({});
clear.args = { color: ButtonColor.CLEAR, label: 'Button' };
clear.hermioneFn = hoverState;

export const invert = Template.bind({});
invert.args = { color: ButtonColor.INVERT, label: 'Button' };
invert.parameters = { backgrounds: { default: 'black' } };
invert.hermioneFn = hoverState;

export const icon = Template.bind({});
icon.args = { color: ButtonColor.SECONDARY, label: 'Button', icon: ArrowBackIcon };
icon.hermioneFn = hoverState;

export const iconOnly = Template.bind({});
iconOnly.args = { color: ButtonColor.SECONDARY, icon: ArrowBackIcon };
iconOnly.hermioneFn = hoverState;

export const iconOnlyClear = Template.bind({});
iconOnlyClear.args = { color: ButtonColor.CLEAR, icon: ArrowBackIcon };
iconOnlyClear.hermioneFn = hoverState;

export const round = Template.bind({});
round.args = { color: ButtonColor.SECONDARY, icon: ArrowBackIcon, round: true };
round.hermioneFn = hoverState;

export const shadow = Template.bind({});
shadow.args = { size: ButtonSize.M, label: 'Button', shadow: true };
shadow.hermioneFn = hoverState;

export const wide = Template.bind({});
wide.args = { color: ButtonColor.SECONDARY, label: 'Button', wide: true };
wide.hermioneFn = hoverState;

export const primaryShadow = Template.bind({});
primaryShadow.args = { color: ButtonColor.PRIMARY, label: 'Button', shadow: true };
primaryShadow.hermioneFn = hoverState;

export const disabled = Template.bind({});
disabled.args = { color: ButtonColor.SECONDARY, label: 'Button', icon: ArrowBackIcon, disabled: true };
disabled.hermioneFn = hoverState;

export const shadowDisabled = Template.bind({});
shadowDisabled.args = { label: 'Button', shadow: true, disabled: true };
shadowDisabled.hermioneFn = hoverState;

export const primaryShadowDisabled = Template.bind({});
primaryShadowDisabled.args = { color: ButtonColor.PRIMARY, label: 'Button', shadow: true, disabled: true };
primaryShadowDisabled.hermioneFn = hoverState;
