import React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { ButtonArrow, ButtonArrowProps } from 'shared/ui/ButtonArrow/ButtonArrow';

const storybookMeta = createStorybookMeta<ButtonArrowProps>({
    title: 'shared/ButtonArrow',
    component: ButtonArrow,

    args: {
        color: ButtonColor.SECONDARY,
        size: ButtonSize.M,
        label: 'Button',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<
    ButtonArrowProps,
    React.ForwardRefExoticComponent<React.PropsWithoutRef<ButtonArrowProps> & React.RefAttributes<any>>
>(ButtonArrow);

export const normal = Template.bind({});

export const opened = Template.bind({});
opened.args = { opened: true };

export const withoutArrow = Template.bind({});
withoutArrow.args = { hasArrow: false };

export const disabled = Template.bind({});
disabled.args = { disabled: true };
