import * as React from 'react';
import cn from 'classnames/bind';

import { Button, ButtonProps } from 'shared/ui/Button/Button';

import ArrowIcon from 'shared/ui/Icons/images/arrow-short-bottom-16.inline.svg';

import styles from 'shared/ui/ButtonArrow/ButtonArrow.css';

export interface ButtonArrowProps extends ButtonProps {
    className?: string;
    opened?: boolean;
    hasArrow?: boolean;
}

const cx = cn.bind(styles);

export const ButtonArrow = React.forwardRef<HTMLElement, ButtonArrowProps>(function ButtonArrow(
    { className, size, opened, hasArrow = true, disabled, ...otherProps },
    ref,
) {
    return (
        <Button
            {...otherProps}
            className={cx(styles.buttonArrow, { opened, disabled }, [size, className])}
            size={size}
            disabled={disabled}
            ref={ref}
        >
            {hasArrow && (
                <span className={styles.arrowIcon}>
                    <ArrowIcon />
                </span>
            )}
        </Button>
    );
});
